/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DESSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public DESSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.DES);
    }

    protected DESSecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DES);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DESSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DESSecretKey dESSecretKey = (DESSecretKey)super.clone();
        dESSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DESSecretKey.putAttributesInTable(dESSecretKey);
        return dESSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DESSecretKey) {
            DESSecretKey dESSecretKey = (DESSecretKey)object;
            bl = this == dESSecretKey || super.equals(dESSecretKey) && this.value_.equals(dESSecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new DESSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DESSecretKey dESSecretKey) {
        if (dESSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dESSecretKey.attributeTable_.put(Attribute.VALUE, dESSecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

